# Debugging Template Integration Issues

## Issues Found:

### 1. ✅ FIXED: Async/await syntax error
**Problem**: Using `await` in non-async message handlers
**Solution**: Wrapped async code in IIFE `(async () => { ... })()`

### 2. ✅ FIXED: Message channel closing
**Problem**: Not returning `true` for async responses
**Solution**: Added `return true` for async message handlers

### 3. 🔍 TO DEBUG: Connection not established

## Debugging Steps:

### Step 1: Verify Extension is Active on TextRad Page
1. Open TextRad web app in browser
2. Log in to TextRad
3. Open Chrome extension popup
4. Check Console for connection status

### Step 2: Check Content Script Injection
Open Browser DevTools → Console on TextRad page and run:
```javascript
console.log('TextRad objects:', {
  textradApp: !!window.textradApp,
  formatManager: !!(window.textradApp?.formatManager),
  isInitialized: window.textradApp?.isInitialized,
  isAuthenticated: window.textradApp?.isAuthenticated
});
```

### Step 3: Test Format Loading Manually
In TextRad page console:
```javascript
if (window.textradApp?.formatManager) {
  const formats = window.textradApp.formatManager.getAllFormats();
  console.log('Available formats:', formats);
} else {
  console.log('FormatManager not available');
}
```

### Step 4: Test Content Script Communication
In extension popup console:
```javascript
chrome.tabs.query({active: true, currentWindow: true}, (tabs) => {
  chrome.tabs.sendMessage(tabs[0].id, {action: 'PING'}, (response) => {
    console.log('Ping response:', response);
  });
});
```

## Expected Behavior:

1. **On TextRad login page**: Extension should detect "not logged in"
2. **On TextRad app page (logged in)**: Extension should detect connection
3. **After transcription**: Template dropdown should appear automatically
4. **After template selection**: Generate button should appear
5. **After clicking Generate**: Report should replace transcription text

## Common Issues & Solutions:

### Issue: "Receiving end does not exist"
**Cause**: Content script not injected or TextRad page not detected
**Solution**:
- Ensure you're on textrad.com or textrad.in domain
- Check that user is logged in
- Try refreshing TextRad page

### Issue: "FormatManager not available"
**Cause**: TextRad app not fully initialized
**Solutions**:
- Wait for page to fully load
- Check if user is properly authenticated
- Verify TextRad app is in working state

### Issue: No templates in dropdown
**Cause**: User has no formats configured
**Solution**: Create formats in TextRad web app first

## Testing Checklist:

- [ ] Extension popup opens
- [ ] TextRad connection indicator shows "connected"
- [ ] Record button works
- [ ] Transcription appears
- [ ] Template dropdown appears after transcription
- [ ] Template dropdown has options
- [ ] Generate button appears after template selection
- [ ] Report generation works
- [ ] Generated report appears in transcription box
- [ ] Copy button works with generated report
