# TextRad Dictation Chrome Extension

This Chrome extension allows users to record dictations and send them directly to the TextRad web application for processing and report generation.

## Features

- Record audio dictations directly from the browser
- Automatic transcription of dictations
- Audio visualization during recording
- Automatic silence detection and recording stop
- Seamless integration with TextRad web app
- Settings customization

## Installation for Development

1. Clone this repository or download the code
2. Open Chrome and navigate to `chrome://extensions/`
3. Enable "Developer mode" by toggling the switch in the top right corner
4. Click "Load unpacked" and select the `textrad-extension` directory
5. The extension should now appear in your Chrome toolbar

## Usage

1. Click the TextRad Dictation extension icon to open the popup
2. Click the microphone button to start recording
3. Speak your dictation clearly
4. Recording will automatically stop after 40 seconds of silence, or you can click the stop button
5. The audio will be transcribed automatically
6. Once transcription is complete, you can:
   - Send the transcription to the TextRad web app
   - Continue recording to add more dictation
   - Adjust settings as needed

## Testing

### Pre-requisites for Testing

1. Make sure you have the TextRad web app open in a tab
2. Ensure you are logged in to the TextRad web app
3. Have a microphone connected and working with Chrome

### Testing Steps

1. **Extension Loading**
   - Ensure the extension loads correctly in Chrome
   - Verify the popup UI appears when clicking the extension icon

2. **Recording Functionality**
   - Test starting and stopping recording
   - Verify the audio visualization works during recording
   - Test silence detection by staying silent for >40 seconds
   - Verify recording time display updates correctly

3. **Transcription Functionality**
   - Verify transcription starts after recording stops
   - Check for accurate transcription results
   - Test error handling by intentionally causing errors (e.g., disconnect microphone mid-recording)

4. **TextRad Integration**
   - Test sending transcription to TextRad web app
   - Verify transcription appears in TextRad's transcription field
   - Test with TextRad tab open and closed
   - Verify the "continue recording" functionality works with existing transcription

5. **Settings**
   - Test saving and loading settings
   - Verify silence timeout setting works as expected
   - Test auto-send functionality

6. **Error Handling**
   - Test with no microphone access
   - Test with no TextRad tab open
   - Test with network connectivity issues

## Known Issues

- Firebase authentication requires the TextRad web app to be open first in some cases
- Some browsers may have additional microphone permission requirements
- Transcription quality depends on audio clarity and background noise

## Packaging for Deployment

To create a distributable package for the Chrome Web Store:

1. Ensure all code is finalized and tested
2. Create proper icon files in all required sizes (16x16, 48x48, 128x128)
3. Update the manifest.json with final version number and descriptions
4. Zip the entire `textrad-extension` directory
5. Submit the zip file to the Chrome Web Store Developer Dashboard

## Troubleshooting

### Microphone Access Issues

If the extension cannot access your microphone:
1. Check Chrome's site permissions for the extension
2. Ensure your microphone is working in other applications
3. Try reloading the extension

### Transcription Problems

If transcription is not working correctly:
1. Ensure you have a good internet connection
2. Make sure you're logged in to TextRad in another tab
3. Check that your microphone is capturing audio clearly
4. Try shorter recordings first to verify functionality

### Communication Problems

If the extension cannot communicate with TextRad:
1. Make sure TextRad is open in a tab
2. Refresh the TextRad page
3. Reload the extension
4. Check for console errors in both extension and TextRad tab

## Development Notes

This extension is built using:
- JavaScript ES6+
- Chrome Extension Manifest V3
- Web Audio API
- MediaRecorder API
- Firebase Authentication and Cloud Functions

The extension architecture follows the standard Chrome extension model with:
- Background script (service worker)
- Content script for TextRad integration
- Popup UI for user interaction
- Shared library modules

## License

See the LICENSE file for details.