/**
 * TextRad Dictation Extension - Mock Firebase
 * 
 * A simplified implementation to work around CSP restrictions in Manifest V3
 */

// Firebase configuration from the TextRad web app
export const firebaseConfig = {
  apiKey: "AIzaSyAxg70Vpl9J9gnzIYsE22UCJ46MkhLd5tE",
  authDomain: "textrad-dc865.firebaseapp.com",
  databaseURL: "https://textrad-dc865-default-rtdb.asia-southeast1.firebasedatabase.app",
  projectId: "textrad-dc865",
  storageBucket: "textrad-dc865.firebasestorage.app",
  messagingSenderId: "757321029257",
  appId: "1:757321029257:web:a70b5d4d73fc8a404c5858",
  measurementId: "G-0JGGMCP10J"
};

// Mock Firebase Auth with anonymous auth
export const auth = {
  currentUser: {
    uid: 'extension-user-' + Math.random().toString(36).substring(2, 15),
    isAnonymous: true
  },
  
  signInAnonymously() {
    console.log('Mock anonymous sign-in');
    return Promise.resolve({ user: this.currentUser });
  }
};

// Mock Firestore (simplified)
export const db = {
  collection(path) {
    return {
      doc(id) {
        return {
          get() {
            return Promise.resolve({
              exists: false,
              data: () => null
            });
          },
          set(data) {
            console.log('Mock document set:', path, id, data);
            return Promise.resolve();
          },
          update(data) {
            console.log('Mock document update:', path, id, data);
            return Promise.resolve();
          }
        };
      }
    };
  }
};

// Mock Firebase Functions
export const functions = {
  httpsCallable(name) {
    // Return a function that simulates the cloud function
    return async (data) => {
      console.log(`Mock function '${name}' called with:`, data);
      
      // For directTranscribe function, simulate transcription response
      if (name === 'directTranscribe') {
        // Simulate network delay
        await new Promise(resolve => setTimeout(resolve, 1500));
        
        // Return mock transcription result
        return { 
          data: { 
            text: "This is a mock transcription from the TextRad extension. The backend API couldn't be reached due to extension security restrictions. Please send this to TextRad and edit it there." 
          } 
        };
      }
      
      return { data: {} };
    };
  }
};

// Mock initialization function
export function initializeApp(config) {
  console.log('Mock Firebase initialized with config:', config);
  return { name: 'textrad-extension' };
}

// Utility functions
export function getFirestore() {
  return db;
}

export function getAuth() {
  return auth;
}

export function getFunctions() {
  return functions;
}

// Log that mock Firebase has been loaded
console.log('Mock Firebase module loaded for extension use');